#svm
set.seed(1234)
flag<-sample(1:nrow(data_train_60),size=floor(0.8 * nrow(data_train_60)))
data_train<-data_train_60_3[flag,]#data_train
data_test<-data_train_60_3[-flag,]#data_test(completely independent)

library("e1071")

set.seed(12345)
tObj<-tune.svm(Fy~.,
               data=data_train,
               type="C-classification",
               kernel="radial",
               #          kernel="linear",
               cost=c(0.001,0.01,0.1,1,5,10,100,1000),
               gamma=c(0.5,1,2,3,4),scale=F)
plot(tObj,
     xlab=expression(gamma),ylab="Loss_penalty_coefficient C",
     main="Prediction error rate under different parameters",
     nlevels=10,color.palette=terrain.colors)

BestSvm<-tObj$best.model
summary(BestSvm)

#plot(x=BestSvm,data=data_train,formula=newcol_CG~newcol_G_C,
#   svSymbol="#",dataSymbol="*",grid=100)
yPred<-predict(BestSvm,data_test)
(ConfM<-table(yPred,data_test$Fy))
a3_svm <- yPred
#write.csv(pred,file = "output.csv", row.names = FALSE)

#
(1-(Err<-(sum(ConfM)-sum(diag(ConfM)))/sum(ConfM)))#accuracy
sensitivity<-(ConfM[1,1]/(ConfM[1,1]+ConfM[1,2]));sensitivity#sensitivity
specificity<-(ConfM[2,2]/(ConfM[2,1]+ConfM[2,2]));specificity#specificity