#ramdomForest
library(randomForest)

set.seed(1234)
flag<-sample(1:nrow(data_train_60_3),size=floor(0.8 * nrow(data_train_60_3)))
data_train<-data_train_60[flag,]#data_train
data_test<-data_train_60[-flag,]#data_test(completely independent)

set.seed(1234)
rFM <- randomForest(Fy~.,data=data_train,importance=T)
rFM

head(rFM$votes)#Probability of prediction for each category of observations
head(rFM$oob.times)#Number of observations as OOB

#DrawL <- par()
#par(mfrow=c(2,1))
##par(mfrow=c(1,1))
#plot(rFM,main="randomForest_OOB Misjudgment Rate and Number of Decision Trees")#Equivalent to drawing a picture of err.rate
#plot(margin(rFM),type="h",
#     main="Boundary point detection",
#     xlab="observation_sequence",ylab="Ratio_difference")#Boundary point detection
#par(DrawL)

head(treesize(rFM))#Browse the number of leaf nodes in each tree
head(getTree(rfobj=rFM,k=1,labelVar=T))#Extract the part of the first tree

pred <- predict(rFM,data_test)
Freq <- table(pred,data_test$Fy);Freq

1-(Err.BP <- (sum(Freq)-sum(diag(Freq)))/sum(Freq))#rFaccuracy
sensitivity<-(Freq[1,1]/(Freq[1,1]+Freq[1,2]));sensitivity#sensitivity
specificity<-(Freq[2,2]/(Freq[2,1]+Freq[2,2]));specificity#specificity