# 2023/10/6 14:25
from scipy.integrate import odeint
from matplotlib.pyplot import MultipleLocator
import numpy as np
import math

import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams["font.sans-serif"] = ["SimHei"]
mpl.rcParams["axes.unicode_minus"] = False

def fun(y,t):

    MA=y[0]
    A=y[1]
    OTa=y[2]

    Tc=100/2169
    Ts=0.0277
    Dm=math.log(2)/(3.96*60)
    Ds=math.log(2)/(15*60)

    p=250
    Km=41.1201
    k1=0.00015

    Cm=0.9363




    z=np.array([Tc*p/(Km+p)-Dm*MA-Ts*MA,\
                Ts*MA-Ds*A,\
                k1*OTa*(1-OTa/Cm)    ])


    return z

tspan=np.array([0,86400]);
h=1
t=np.arange(tspan[0],tspan[1]+h,h)
t1=np.arange(0,24,1/3600)

y0=np.array([250,0,0.001])
Y0 = odeint(fun, y0, t)


##stability analysis

y1=np.array([250,0,0.001*0.85])
Y1= odeint(fun, y1, t)

y2=np.array([250,0,0.001*0.9])
Y2=odeint(fun, y2, t)

y3=np.array([250,0,0.001*0.95])
Y3=odeint(fun, y3, t)

y4=np.array([250,0,0.001*1.05])
Y4=odeint(fun, y4, t)

y5=np.array([250,0,0.001*1.1])
Y5=odeint(fun, y5, t)

y6=np.array([250,0,0.001*1.15])
Y6=odeint(fun, y6, t)


y00=[Y1[86400,2],Y2[86400,2],Y3[86400,2],Y0[86400,2],Y4[86400,2],Y5[86400,2],Y6[86400,2]]
x00=[-0.15,-0.1,-0.05,0,0.05,0.1,0.15]

font = {'family' : 'Times New Roman',
            'weight' : 'normal',
            'size'   : 18,}
plt.plot(x00,y00)
plt.scatter(x00,y00,marker='o',color='b',label='Concentration of OTα in different Paramater disturbance quality')
plt.grid()
plt.xlabel('Different paramater disturbance quality',font)
plt.ylabel('Concentration of OTα(μg/ml)',font)
plt.title('Concentration of OTα by different disturbance',font)

plt.xticks(fontproperties = 'Times New Roman', size = 18)
plt.yticks(fontproperties = 'Times New Roman', size = 18)
plt.tight_layout()
plt.show()

'''
plt.plot(t[:86400]/3600,Y1[:86400,2],label='Paramater disturbance quality:-0.15',color='#0050B6',linewidth=2)
plt.plot(t[:86400]/3600,Y2[:86400,2],label='Paramater disturbance quality:-0.1',color='#A84DB1',linewidth=2)
plt.plot(t[:86400]/3600,Y3[:86400,2],label='Paramater disturbance quality:-0.05',color='#F25894',linewidth=2)
plt.plot(t[:86400]/3600,Y0[:86400,2],label='Paramater disturbance quality:0',color='black',linewidth=2)

plt.plot(t[:86400]/3600,Y4[:86400,2],label='Paramater disturbance quality:0.05',color='#FF8370',linewidth=2)
plt.plot(t[:86400]/3600,Y5[:86400,2],label='Paramater disturbance quality:0.1',color='#FFBE5B',linewidth=2)
plt.plot(t[:86400]/3600,Y6[:86400,2],label='Paramater disturbance quality:0.15',color='#F9F871',linewidth=2)



plt.ylabel('concentration(μg/ml)',font)
plt.xlabel('Time(h)',font)
plt.title('Concentration change of OTα',font)
plt.ylim(0,1)
plt.xlim(0,24)
plt.legend(prop={'family' : 'Times New Roman', 'size'   : 10})
plt.xticks(fontproperties = 'Times New Roman', size = 18)
plt.yticks(fontproperties = 'Times New Roman', size = 18)
plt.tight_layout()
#fig.subplots_adjust(left=left, bottom=bottom, right=1 - left, top=1 - bottom)
plt.show()
'''
